#include <iostream>
#include <fstream>
#include <algorithm>
#include <map>
#include <vector>
#include <set>
#include <iomanip>
#include <string>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <cstring>

#define DBG_

typedef long long ll;

using namespace std;

/*
set<int> parse(string s) {
	set<int> result;
#ifdef DBG
	cout << "Switches turned on:" << endl;
#endif
	for (int i = 0; i < (int)s.length(); ++i) {
		if (s[i] == '1') {
			result.insert(i);
#ifdef DBG
			cout << i << ' ';
#endif
		}
	}
#ifdef DBG
	cout << endl;
#endif
	return result;
}
*/

ll parseOps(string s) {
	ll result = 0;
#ifdef DBG2
	cout << "Switches operated:" << endl;
#endif
	for (int i = 0; i < (int)s.length(); ++i) {
		result |= (s[i] - '0') << i;
#ifdef DBG2
		if (s[i] == '1')
			cout << i << ' ';
#endif
	}
#ifdef DBG2
	cout << endl;
#endif
	return result;
}

char switchName(int sw) {
	if (sw < 10)
		return (char)(sw + '0');

	return (char)(sw - 10 + 'A');
}

int main() {
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);

	int n, m, q;
	cin >> n >> m >> q;
#ifdef DBG
	cout << n << ' ' << m << ' ' << q << endl;
#endif

	ll wrongSwitches[1000];
	//set<int> applicableSwitches[1000];
	while (n > 0) {
		/*
		for (int i = 0; i < m; ++i) {
			applicableSwitches[i].clear();
#ifdef DBG
			cout << "Switches applicable for bulb #" << i << ':' << endl;
#endif
			for (int j = 0; j < n; ++j) {
				applicableSwitches[i].insert(j);
#ifdef DBG
				cout << j << ' ';
#endif
			}
#ifdef DBG
			cout << endl;
#endif
		}
		*/
		memset(wrongSwitches, 0, sizeof(wrongSwitches));

		//set<int> on;
		ll onSwitches = 0;
		for (int j = 0; j < q; ++j) {
			string s;
			cin >> s;
			onSwitches ^= parseOps(s);
#ifdef DBG
			cout << "ON switches:" << endl;
			for (ll k = 0; k < n; ++k) {
				if ((onSwitches & (1LL << k)) != 0)
					cout << k << ' ';
			}
			cout << endl;
#endif
			/*
			set<int> changed = parse(s);
			for (set<int>::iterator it = changed.begin(); it != changed.end(); ++it) {
				set<int>::iterator existing = on.find(*it);
				if (existing != on.end()) {
					on.erase(existing);
#ifdef DBG
					cout << "Turned off switch #" << *it << endl;
#endif
				} else {
					on.insert(*it);
#ifdef DBG
					cout << "Turned on switch #" << *it << endl;
#endif
				}
			}
			*/
			cin >> s;
			for (int i = 0; i < m; ++i) {
				if (s[i] == '1') {
					// bulb is ONLINE
					// all disabled switches are WRONG
					wrongSwitches[i] |= ~onSwitches;
				} else {
					// bulb is OFFLINE
					// all enabled switches are WRONG
					wrongSwitches[i] |= onSwitches;
				}

#ifdef DBG
				cout << "PROBABLE switches for bulb #" << i << ":" << endl;
				for (ll k = 0; k < n; ++k) {
					if ((wrongSwitches[i] & (1LL << k)) == 0)
						cout << k << ' ';
				}
				cout << endl;
#endif

				/*
				if (s[i] == '1') {
#ifdef DBG
					cout << "Bulb #" << i << " IS ON" << endl;
#endif
					set<int> neu;
					for (set<int>::iterator it = applicableSwitches[i].begin(); it != applicableSwitches[i].end(); ++it) {
						if (on.find(*it) != on.end())
							neu.insert(*it);
					}
					applicableSwitches[i] = neu;
#ifdef DBG
					cout << "Newly applicable switches:" << endl;
					for (set<int>::iterator it = neu.begin(); it != neu.end(); ++it)
						cout << *it << ' ';
					cout << endl;
#endif
				} else {
#ifdef DBG
					cout << "Bulb #" << i << " IS OFF" << endl;
#endif

					if (on.empty()) {
#ifdef DBG
						cout << "No change" << endl;
#endif
						continue;
					}

					set<int> neu;
					for (set<int>::iterator it = applicableSwitches[i].begin(); it != applicableSwitches[i].end(); ++it) {
						if (on.find(*it) == on.end())
							neu.insert(*it);
					}
					applicableSwitches[i] = neu;
#ifdef DBG
					cout << "Newly applicable switches:" << endl;
					for (set<int>::iterator it = neu.begin(); it != neu.end(); ++it)
						cout << *it << ' ';
					cout << endl;
#endif
				}
				*/
			}
		}

		for (int i = 0; i < m; ++i) {
			/*
			if (applicableSwitches[i].size() != 1) {
				cout << '?';
				continue;
			}

			cout << switchName(*(applicableSwitches[i].begin()));
			*/

			/* doesn't work and IDC
			int actualSwitch = -1;
			for (ll j = 0; j < n; ++j) {
				if ((wrongSwitches[i] & (1LL << j)) != 0)
					continue;

				if (actualSwitch != -1) {
					actualSwitch = -1;
					break;
				}

				actualSwitch = (int)j;
			}

			cout << (actualSwitch > 0) ? switchName(actualSwitch) : '?';
			*/

			// does work, tested above
			int correctSwitch = -1;
			for (ll k = 0; k < n; ++k) {
				if ((wrongSwitches[i] & (1LL << k)) == 0) {
					if (correctSwitch == -1) {
						correctSwitch = (int)k;
						//cout << "correct switch is now: " << k << endl;
					} else {
						correctSwitch = -1;
						//cout << "duped correct switch: " << k << endl;
						break;
					}
				}
			}

			if (correctSwitch >= 0)
				cout << switchName(correctSwitch);
			else
				cout << '?';

			//cout << (correctSwitch >= 0) ? switchName(correctSwitch) : '?';
		}
		cout << endl;

		cin >> n >> m >> q;
#ifdef DBG
		cout << n << ' ' << m << ' ' << q << endl;
#endif
	}

	return 0;
}
